<?xml version="1.0"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dir="http://apache.org/cocoon/directory/2.0">

   <xsl:param name="cssfile"/>
      
   <xsl:template match="page">
      <html>
        <head>
			<link rel="stylesheet" href="{$cssfile}" type="text/css"/>
	
			<title>INJAC</title>
        </head>
		<body>
            <xsl:apply-templates />
			<a href="../?cssfile={$cssfile}"><i>retour</i></a>
        </body>

      </html>
   </xsl:template>
   
   <xsl:template match="styleCss">
	  <div id="listeCSS">
         <form>
            <select name="stylesheetList" onchange="javascript:location.href=(this.options[this.selectedIndex].value)">
               <xsl:apply-templates select="cssName" />
            </select>
         </form>
      </div>
   </xsl:template>

   <xsl:template match="cssName">
      <option value=".?cssfile={.}">
         <xsl:value-of select="."/>
      </option>
   </xsl:template>
   
   <xsl:template match="dirgen">

      <div id="leftMenu">
      	<ul type="disc" id="currentFolder">
         <xsl:apply-templates />
		</ul>
      </div>
   </xsl:template>

   <xsl:template match="current">   	  
   	  <li id="currentName"><xsl:value-of select="name"/></li>
   </xsl:template>

   <xsl:template match="directory">
 
      <li class="directory">		
		<a href="./publications/{name}/?cssfile={$cssfile}&amp;path={name}">
		
			<xsl:value-of select="name" />
		</a>      	
        <ul type="circle">
			<li id="directoryDate"><xsl:value-of select="date" /></li>
			<li id="directorySize"><xsl:value-of select="size" /></li>
		</ul>
      </li>
   </xsl:template>

   <xsl:template match="file">
      
	  <li class="file">
		<a href="./publications/{name}/?cssfile={$cssfile}">
			<xsl:value-of select="name" />
		</a>
        <ul type="circle">
			<li id="fileDate"><xsl:value-of select="date" /></li>
			<li id="fileSize"><xsl:value-of select="size" /></li>
		</ul>
      </li>
      
   </xsl:template>
   
   <xsl:template match="body">
   		 <div id="HTMLDocument">
   		 	<xsl:value-of select="." />
         </div>
   </xsl:template>  

</xsl:stylesheet>

